class MessageListener {
	eventHandlers = {};

	constructor() {
		window.addEventListener("message", (event) => {
			if (!event || !event.data || !event.data.action) return;

			const func = this.eventHandlers[event.data.action];
			if (func) func(event.data);
		});
	}

	addHandler(actionName, func) {
		this.eventHandlers[actionName] = async function (data) {
			func(data);
		};
	}
}

const messageListener = new MessageListener();

messageListener.addHandler(
	"notify", 
	({ type, title, message, time }) =>
		createNotify(type || "sucesso", title || " ", message || " ", time || 3000)
);

messageListener.addHandler(
	"itemNotify", 
	({ type, index, name, amount, time }) => 
		createItemNotify(type, index, name, amount, time )
);

messageListener.addHandler(
	"announce", 
	({ title, message, author, time }) => 
		createAnnounce(title, message, author, time)
);

messageListener.addHandler(
	"deleteAnnounce", 
	({}) => deleteAnnounce()
);